<?php
// Inicia a sessão para acessar os dados do usuário.
session_start();

// Verifica se o usuário está logado e se o perfil é de professor.
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'PROFESSOR') {
    header("Location: login.php");
    exit;
}

// Inclui o arquivo de conexão com o banco de dados.
include 'conexao.php';
// Inclui o arquivo que verifica o login, se necessário.
include 'verifica_login.php';

// Obtém os dados do usuário da sessão.
$usuario = $_SESSION['usuario'];
$nome_usuario = $usuario['nome'] ?? 'Professor';

// Lógica de processamento do formulário de avaliação pedagógica
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Aqui você colocaria a lógica para salvar a avaliação no banco de dados.
    // Exemplo:
    // $criterio_1 = $_POST['criterio_1'];
    // $comentarios = $_POST['comentarios'];
    // ...
    // echo "<script>alert('Avaliação salva com sucesso!');</script>";
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Avaliação Pedagógica - SISMAG</title>
    <link rel="stylesheet" href="https://rsms.me/inter/inter.css">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-8">

<div class="max-w-4xl mx-auto bg-white p-6 rounded-xl shadow-md">
    <h1 class="text-2xl font-bold text-gray-800 mb-6">Avaliação Pedagógica</h1>
    <p class="text-gray-600 mb-4">Olá, professor(a) <?= htmlspecialchars($nome_usuario) ?>. Use este espaço para registrar suas avaliações pedagógicas.</p>

    <form action="avaliacao_pedagogica.php" method="POST" class="space-y-4">
        <div>
            <label for="aluno" class="block text-sm font-medium text-gray-700">Aluno</label>
            <select id="aluno" name="aluno" class="mt-1 block w-full px-3 py-2 bg-white border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                <option>Aluno 1</option>
                <option>Aluno 2</option>
            </select>
        </div>
        <div>
            <label for="observacoes" class="block text-sm font-medium text-gray-700">Observações</label>
            <textarea id="observacoes" name="observacoes" rows="5" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="Digite suas observações pedagógicas aqui..."></textarea>
        </div>
        <div>
            <button type="submit" class="w-full inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                Salvar Avaliação
            </button>
        </div>
    </form>
</div>

</body>
</html>


